<?php

function copyIMG($url,$saveto){
    $ch = curl_init ($url);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_BINARYTRANSFER,1);
    $raw=curl_exec($ch);
    curl_close ($ch);
    if(file_exists($saveto)){
        unlink($saveto);
    }
    $upload = wp_upload_dir();
	$upload_dir = $upload['basedir'];
	$upload_dir = $upload_dir . '/siteshot';
	wp_mkdir_p( $upload_dir );
	file_put_contents($saveto, $raw);
    //$fp = fopen($saveto,'x');
    //fwrite($fp, $raw);
    //fclose($fp);
}

function siteshot($dataseourl){
	$siteshot_dir = wp_upload_dir();
	$siteshot_file = $siteshot_dir['baseurl'].'/siteshot/'.$dataseourl.'.jpg';
	if (file_exists($siteshot_dir['basedir'].'/siteshot/'.$dataseourl.'.jpg')) {
		$siteshot = $siteshot_file;
	}else{
		$siteshot = 'http://mini.site-shot.com/1024x768/600/jpeg/?'.$dataseourl;
		$newfile = $siteshot_dir['basedir'].'/siteshot/'.$dataseourl.'.jpg';
		if (copyIMG($siteshot, $newfile)) {
			$siteshot = $siteshot_file;
		}else{
			$siteshot = 'http://mini.site-shot.com/1024x768/600/jpeg/?'.$dataseourl;
		}
	}
	return $siteshot;
}

function load_xml($url) {
	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	$result = curl_exec($curl);
	curl_close($curl);
	return simplexml_load_string($result);  
}

function urlExists($url=NULL){
    if($url == NULL) return false;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $data = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch); 
    if($httpcode>=200 && $httpcode<308 || $httpcode=406){
    	return true;
    } else {
    	return false;
    }
    //return $httpcode;
}

function getSEOcache($url) {
	$ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $result = curl_exec($ch);
    curl_close($ch);
	return $result;
}

function curl_exec_utf8($ch) {
    //$ch = curl_init();
	$data = curl_exec($ch);
    if (!is_string($data)) return $data;

    unset($charset);
    $content_type = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);

    /* 1: HTTP Content-Type: header */
    preg_match( '@([\w/+]+)(;\s*charset=(\S+))?@i', $content_type, $matches );
    if ( isset( $matches[3] ) )
        $charset = $matches[3];

    /* 2: <meta> element in the page */
    if (!isset($charset)) {
        preg_match( '@<meta\s+http-equiv="Content-Type"\s+content="([\w/]+)(;\s*charset=([^\s"]+))?@i', $data, $matches );
        if ( isset( $matches[3] ) )
            $charset = $matches[3];
    }

    /* 3: <xml> element in the page */
    if (!isset($charset)) {
        preg_match( '@<\?xml.+encoding="([^\s"]+)@si', $data, $matches );
        if ( isset( $matches[1] ) )
            $charset = $matches[1];
    }

    /* 4: PHP's heuristic detection */
    if (!isset($charset)) {
        $encoding = mb_detect_encoding($data);
        if ($encoding)
            $charset = $encoding;
    }

    /* 5: Default for HTML */
    if (!isset($charset)) {
        if (strstr($content_type, "text/html") === 0)
            $charset = "ISO 8859-1";
    }

    /* Convert it if it is anything but UTF-8 */
    /* You can change "UTF-8"  to "UTF-8//IGNORE" to 
       ignore conversion errors and still output something reasonable */
    if (isset($charset) && strtoupper($charset) != "UTF-8")
        $data = iconv($charset, 'UTF-8', $data);

    return $data;
}

function get_siteData($urlweb) {
	$siteData_file_get_contents = @file_get_contents($urlweb);
	if($siteData_file_get_contents === FALSE) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_HEADER, 1);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $urlweb);
		curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		//curl_setopt($ch, CURLOPT_REFERER, "https://shatmanov.com/");
		//$siteData = curl_exec($ch);
		$siteData = curl_exec_utf8($ch);
		curl_close($ch);
	}else {
		$siteData = $siteData_file_get_contents;
	}	
	return $siteData;
}

function get_city($webip) {
	$IP_cache = SEO_ANALYZER_INC_URL.'/cache/'.$webip;
    if(file_exists($IP_cache)){
		//кэш есть
		//$data = getSEOcache($IP_cache);
		$data = file_get_contents($IP_cache);
	}else{
		$data = get_siteData('http://ipinfo.io/'.$webip.'/json');
		file_put_contents($IP_cache,$data);
	}
	
	$details = json_decode($data);
	switch ($details->country) {
		case 'AF':
			$country = 'Afghanistan';
		break;
		case 'AL':
			$country = 'Albania';
		break;
		case 'DZ':
			$country = 'Algeria';
		break;
		case 'AS':
			$country = 'American Samoa';
		break;
		case 'AD':
			$country = 'Andorra';
		break;
		case 'AO':
			$country = 'Angola';
		break;
		case 'AI':
			$country = 'Anguilla';
		break;
		case 'AQ':
			$country = 'Antarctica';
		break;
		case 'AG':
			$country = 'Antigua and Barbuda';
		break;
		case 'AR':
			$country = 'Argentina';
		break;
		case 'AM':
			$country = 'Armenia';
		break;
		case 'AW':
			$country = 'Aruba';
		break;
		case 'AU':
			$country = 'Australia';
		break;
		case 'AT':
			$country = 'Austria';
		break;
		case 'AZ':
			$country = 'Azerbaijan';
		break;
		case 'BS':
			$country = 'Bahamas';
		break;
		case 'BH':
			$country = 'Bahrain';
		break;
		case 'BD':
			$country = 'Bangladesh';
		break;
		case 'BB':
			$country = 'Barbados';
		break;
		case 'BY':
			$country = 'Belarus';
		break;
		case 'BE':
			$country = 'Belgium';
		break;
		case 'BZ':
			$country = 'Belize';
		break;
		case 'BJ':
			$country = 'Benin';
		break;
		case 'BM':
			$country = 'Bermuda';
		break;
		case 'BT':
			$country = 'Bhutan';
		break;
		case 'BO':
			$country = 'Bolivia';
		break;
		case 'BA':
			$country = 'Bosnia and Herzegovina';
		break;
		case 'BW':
			$country = 'Botswana';
		break;
		case 'BR':
			$country = 'Brazil';
		break;
		case 'IO':
			$country = 'British Indian Ocean Territory';
		break;
		case 'VG':
			$country = 'British Virgin Islands';
		break;
		case 'BN':
			$country = 'Brunei';
		break;
		case 'BG':
			$country = 'Bulgaria';
		break;
		case 'BF':
			$country = 'Burkina Faso';
		break;
		case 'MM':
			$country = 'Myanmar';
		break;
		case 'BI':
			$country = 'Burundi';
		break;
		case 'KH':
			$country = 'Cambodia';
		break;
		case 'CM':
			$country = 'Cameroon';
		break;
		case 'CA':
			$country = 'Canada';
		break;
		case 'CV':
			$country = 'Cape Verde';
		break;
		case 'KY':
			$country = 'Cayman Islands';
		break;
		case 'CF':
			$country = 'Central African Republic';
		break;
		case 'TD':
			$country = 'Chad';
		break;
		case 'CL':
			$country = 'Chile';
		break;
		case 'CN':
			$country = 'China';
		break;
		case 'CX':
			$country = 'Christmas Island';
		break;
		case 'CC':
			$country = 'Cocos Islands';
		break;
		case 'CO':
			$country = 'Colombia';
		break;
		case 'KM':
			$country = 'Comoros';
		break;
		case 'CG':
			$country = 'Republic of the Congo';
		break;
		case 'CD':
			$country = 'Democratic Republic of the Congo';
		break;
		case 'CK':
			$country = 'Cook Islands';
		break;
		case 'CR':
			$country = 'Costa Rica';
		break;
		case 'HR':
			$country = 'Croatia';
		break;
		case 'CU':
			$country = 'Cuba';
		break;
		case 'CW':
			$country = 'Curacao';
		break;
		case 'CY':
			$country = 'Cyprus';
		break;
		case 'CZ':
			$country = 'Czech Republic';
		break;
		case 'DK':
			$country = 'Denmark';
		break;
		case 'DJ':
			$country = 'Djibouti';
		break;
		case 'DM':
			$country = 'Dominica';
		break;
		case 'DO':
			$country = 'Dominican Republic';
		break;
		case 'TL':
			$country = 'East Timor';
		break;
		case 'EC':
			$country = 'Ecuador';
		break;
		case 'EG':
			$country = 'Egypt';
		break;
		case 'SV':
			$country = 'El Salvador';
		break;
		case 'GQ':
			$country = 'Equatorial Guinea';
		break;
		case 'ER':
			$country = 'Eritrea';
		break;
		case 'EE':
			$country = 'Estonia';
		break;
		case 'ET':
			$country = 'Ethiopia';
		break;
		case 'FK':
			$country = 'Falkland Islands';
		break;
		case 'FO':
			$country = 'Faroe Islands';
		break;
		case 'FJ':
			$country = 'Fiji';
		break;
		case 'FI':
			$country = 'Finland';
		break;
		case 'FR':
			$country = 'France';
		break;
		case 'PF':
			$country = 'French Polynesia';
		break;
		case 'GA':
			$country = 'Gabon';
		break;
		case 'GM':
			$country = 'Gambia';
		break;
		case 'GE':
			$country = 'Georgia';
		break;
		case 'DE':
			$country = 'Germany';
		break;
		case 'GH':
			$country = 'Ghana';
		break;
		case 'GI':
			$country = 'Gibraltar';
		break;
		case 'GR':
			$country = 'Greece';
		break;
		case 'GL':
			$country = 'Greenland';
		break;
		case 'GD':
			$country = 'Grenada';
		break;
		case 'GU':
			$country = 'Guam';
		break;
		case 'GT':
			$country = 'Guatemala';
		break;
		case 'GG':
			$country = 'Guernsey';
		break;
		case 'GN':
			$country = 'Guinea';
		break;
		case 'GW':
			$country = 'Guinea-Bissau';
		break;
		case 'GY':
			$country = 'Guyana';
		break;
		case 'HT':
			$country = 'Haiti';
		break;
		case 'HN':
			$country = 'Honduras';
		break;
		case 'HK':
			$country = 'Hong Kong';
		break;
		case 'HU':
			$country = 'Hungary';
		break;
		case 'IS':
			$country = 'Iceland';
		break;
		case 'IN':
			$country = 'India';
		break;
		case 'ID':
			$country = 'Indonesia';
		break;
		case 'IR':
			$country = 'Iran';
		break;
		case 'IQ':
			$country = 'Iraq';
		break;
		case 'IE':
			$country = 'Ireland';
		break;
		case 'IM':
			$country = 'Isle of Man';
		break;
		case 'IL':
			$country = 'Israel';
		break;
		case 'IT':
			$country = 'Italy';
		break;
		case 'CI':
			$country = 'Ivory Coast';
		break;
		case 'JM':
			$country = 'Jamaica';
		break;
		case 'JP':
			$country = 'Japan';
		break;
		case 'JE':
			$country = 'Jersey';
		break;
		case 'JO':
			$country = 'Jordan';
		break;
		case 'KZ':
			$country = 'Kazakhstan';
		break;
		case 'KE':
			$country = 'Kenya';
		break;
		case 'KI':
			$country = 'Kiribati';
		break;
		case 'XK':
			$country = 'Kosovo';
		break;
		case 'KW':
			$country = 'Kuwait';
		break;
		case 'KG':
			$country = 'Kyrgyzstan';
		break;
		case 'LA':
			$country = 'Laos';
		break;
		case 'LV':
			$country = 'Latvia';
		break;
		case 'LB':
			$country = 'Lebanon';
		break;
		case 'LS':
			$country = 'Lesotho';
		break;
		case 'LR':
			$country = 'Liberia';
		break;
		case 'LY':
			$country = 'Libya';
		break;
		case 'LI':
			$country = 'Liechtenstein';
		break;
		case 'LT':
			$country = 'Lithuania';
		break;
		case 'LU':
			$country = 'Luxembourg';
		break;
		case 'MO':
			$country = 'Macao';
		break;
		case 'MK':
			$country = 'Macedonia';
		break;
		case 'MG':
			$country = 'Madagascar';
		break;
		case 'MW':
			$country = 'Malawi';
		break;
		case 'MY':
			$country = 'Malaysia';
		break;
		case 'MV':
			$country = 'Maldives';
		break;
		case 'ML':
			$country = 'Mali';
		break;
		case 'MT':
			$country = 'Malta';
		break;
		case 'MH':
			$country = 'Marshall Islands';
		break;
		case 'MR':
			$country = 'Mauritania';
		break;
		case 'MU':
			$country = 'Mauritius';
		break;
		case 'YT':
			$country = 'Mayotte';
		break;
		case 'MX':
			$country = 'Mexico';
		break;
		case 'FM':
			$country = 'Micronesia';
		break;
		case 'MD':
			$country = 'Moldova';
		break;
		case 'MC':
			$country = 'Monaco';
		break;
		case 'MN':
			$country = 'Mongolia';
		break;
		case 'ME':
			$country = 'Montenegro';
		break;
		case 'MS':
			$country = 'Montserrat';
		break;
		case 'MA':
			$country = 'Morocco';
		break;
		case 'MZ':
			$country = 'Mozambique';
		break;
		case 'NA':
			$country = 'Namibia';
		break;
		case 'NR':
			$country = 'Nauru';
		break;
		case 'NP':
			$country = 'Nepal';
		break;
		case 'NL':
			$country = 'Netherlands';
		break;
		case 'AN':
			$country = 'Netherlands Antilles';
		break;
		case 'NC':
			$country = 'New Caledonia';
		break;
		case 'NZ':
			$country = 'New Zealand';
		break;
		case 'NI':
			$country = 'Nicaragua';
		break;
		case 'NE':
			$country = 'Niger';
		break;
		case 'NG':
			$country = 'Nigeria';
		break;
		case 'NU':
			$country = 'Niue';
		break;
		case 'MP':
			$country = 'Northern Mariana Islands';
		break;
		case 'KP':
			$country = 'North Korea';
		break;
		case 'NO':
			$country = 'Norway';
		break;
		case 'OM':
			$country = 'Oman';
		break;
		case 'PK':
			$country = 'Pakistan';
		break;
		case 'PW':
			$country = 'Palau';
		break;
		case 'PS':
			$country = 'Palestine';
		break;
		case 'PA':
			$country = 'Panama';
		break;
		case 'PG':
			$country = 'Papua New Guinea';
		break;
		case 'PY':
			$country = 'Paraguay';
		break;
		case 'PE':
			$country = 'Peru';
		break;
		case 'PH':
			$country = 'Philippines';
		break;
		case 'PN':
			$country = 'Pitcairn';
		break;
		case 'PL':
			$country = 'Poland';
		break;
		case 'PT':
			$country = 'Portugal';
		break;
		case 'PR':
			$country = 'Puerto Rico';
		break;
		case 'QA':
			$country = 'Qatar';
		break;
		case 'RE':
			$country = 'Reunion';
		break;
		case 'RO':
			$country = 'Romania';
		break;
		case 'RU':
			$country = 'Russia';
		break;
		case 'RW':
			$country = 'Rwanda';
		break;
		case 'BL':
			$country = 'Saint Barthelemy';
		break;
		case 'WS':
			$country = 'Samoa';
		break;
		case 'SM':
			$country = 'San Marino';
		break;
		case 'ST':
			$country = 'Sao Tome and Principe';
		break;
		case 'SA':
			$country = 'Saudi Arabia';
		break;
		case 'SN':
			$country = 'Senegal';
		break;
		case 'RS':
			$country = 'Serbia';
		break;
		case 'SC':
			$country = 'Seychelles';
		break;
		case 'SL':
			$country = 'Sierra Leone';
		break;
		case 'SG':
			$country = 'Singapore';
		break;
		case 'SX':
			$country = 'Sint Maarten';
		break;
		case 'SK':
			$country = 'Slovakia';
		break;
		case 'SI':
			$country = 'Slovenia';
		break;
		case 'SB':
			$country = 'Solomon Islands';
		break;
		case 'SO':
			$country = 'Somalia';
		break;
		case 'ZA':
			$country = 'South Africa';
		break;
		case 'KR':
			$country = 'South Korea';
		break;
		case 'SS':
			$country = 'South Sudan';
		break;
		case 'ES':
			$country = 'Spain';
		break;
		case 'LK':
			$country = 'Sri Lanka';
		break;
		case 'SH':
			$country = 'Saint Helena';
		break;
		case 'KN':
			$country = 'Saint Kitts and Nevis';
		break;
		case 'LC':
			$country = 'Saint Lucia';
		break;
		case 'MF':
			$country = 'Saint Martin';
		break;
		case 'PM':
			$country = 'Saint Pierre and Miquelon';
		break;
		case 'VC':
			$country = 'Saint Vincent and the Grenadines';
		break;
		case 'SD':
			$country = 'Sudan';
		break;
		case 'SR':
			$country = 'Suriname';
		break;
		case 'SJ':
			$country = 'Svalbard and Jan Mayen';
		break;
		case 'SZ':
			$country = 'Swaziland';
		break;
		case 'SE':
			$country = 'Sweden';
		break;
		case 'CH':
			$country = 'Switzerland';
		break;
		case 'SY':
			$country = 'Syria';
		break;
		case 'TW':
			$country = 'Taiwan';
		break;
		case 'TJ':
			$country = 'Tajikistan';
		break;
		case 'TZ':
			$country = 'Tanzania';
		break;
		case 'TH':
			$country = 'Thailand';
		break;
		case 'TG':
			$country = 'Togo';
		break;
		case 'TK':
			$country = 'Tokelau';
		break;
		case 'TO':
			$country = 'Tonga';
		break;
		case 'TT':
			$country = 'Trinidad and Tobago';
		break;
		case 'TN':
			$country = 'Tunisia';
		break;
		case 'TR':
			$country = 'Turkey';
		break;
		case 'TM':
			$country = 'Turkmenistan';
		break;
		case 'TC':
			$country = 'Turks and Caicos Islands';
		break;
		case 'TV':
			$country = 'Tuvalu';
		break;
		case 'AE':
			$country = 'United Arab Emirates';
		break;
		case 'UG':
			$country = 'Uganda';
		break;
		case 'GB':
			$country = 'United Kingdom';
		break;
		case 'UA':
			$country = 'Ukraine';
		break;
		case 'UY':
			$country = 'Uruguay';
		break;
		case 'US':
			$country = 'United States';
		break;
		case 'UZ':
			$country = 'Uzbekistan';
		break;
		case 'VU':
			$country = 'Vanuatu';
		break;
		case 'VA':
			$country = 'Vatican';
		break;
		case 'VE':
			$country = 'Venezuela';
		break;
		case 'VN':
			$country = 'Vietnam';
		break;
		case 'VI':
			$country = 'U.S. Virgin Islands';
		break;
		case 'WF':
			$country = 'Wallis and Futuna';
		break;
		case 'EH':
			$country = 'Western Sahara';
		break;
		case 'YE':
			$country = 'Yemen';
		break;
		case 'ZM':
			$country = 'Zambia';
		break;
		case 'ZW':
			$country = 'Zimbabwe';
		break;
		
		default:
			$country = 'Unknown Country';
	}
	return $country;
}

function get_map($webip) {
	$IP_cache = SEO_ANALYZER_INC_URL.'/cache/'.$webip;
    if(file_exists($IP_cache)){
		//кэш есть
		$data = file_get_contents($IP_cache);
	}else{
		$data = get_siteData('http://ipinfo.io/'.$webip.'/json');
		file_put_contents($IP_cache,$data);
	}
	$mdetails = json_decode($data);
	return $mdetails->loc;
}

function get_dns($domain) {
	$dns_cache = SEO_ANALYZER_INC_URL.'/cache/'.$domain.'.dns';
	$data = file_get_contents($dns_cache);
	$data = json_decode($data);
	$result_dns = '';
	foreach ($data->dig->additional as $ns) {
    	if ($ns->type == 'A'){
			$result_dns .= $ns->name.'<br>';
		}
	}
	if(empty($result_dns)){
		$result = dns_get_record($domain, DNS_NS);
		foreach ($result as $ns) {
    		if ($ns['type'] == 'NS'){
				$result_dns .= $ns['target'].'<br>';
			}
		}
	}
	return $result_dns;
}

function getIP($domain) {
	$dns_cache = SEO_ANALYZER_INC_URL.'/cache/'.$domain.'.dns';
	$data = file_get_contents($dns_cache);
	$data = json_decode($data);
	foreach ($data->dig->answer as $r) {
		if ($r->type == 'A'){
			$res = $r->rdata;
			break;
		}
	}
	if (empty($res)){
		foreach ($data->dig->additional as $r) {
			if ($r->type == 'A'){
				$res = $r->rdata;
				break;
			}
		}
	}
	if (empty($res)){
		$res = gethostbyname($domain);
	}
	return $res;
}

function webPageSD($url) {

  $start = gettimeofday(); //начало
  get_siteData($url);
  $end = gettimeofday();
  $result = (float)($end['sec'] - $start['sec']) + ((float)($end['usec'] - $start['usec'])/1000000);

  return $result;
}

function get_GPSpeed($url, $type) {  
  if($type == 'desktop'){
	  $GS_cache = SEO_ANALYZER_INC_URL.'/cache/'.$url.'.gs';
	  $data = get_siteData($GS_cache);
	  $result = json_decode($data,true);
  }else if($type == 'mobile'){
	  $GS_cache = SEO_ANALYZER_INC_URL.'/cache/'.$url.'.gsm';
	  $data = get_siteData($GS_cache);
	  $result = json_decode($data,true);
  }
  return $result;
}


function w3HTML($url) {  
    $ch = curl_init('https://validator.w3.org/nu/?doc=http%3A%2F%2F'.$url.'%2F&out=json');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $headers = [
    	'Content-Type: text/html; charset=UTF-8',
    	'User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36',
	];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $datasss = curl_exec($ch);
    curl_close($ch);
	
  $datasss = json_decode($datasss);
  $errc = '0';
  if(!empty($datasss->messages)){
  	foreach ($datasss->messages as $error) {
  		if ($error->type == 'error'){
  			$errc++;
  		}
  	}
  }
  return $errc;
}

function w3CSS($url) {  
    $ch = curl_init('https://jigsaw.w3.org/css-validator/validator?uri=http%3A%2F%2F'.$url.'%2F&output=json');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $headers = [
    	'Content-Type: text/html; charset=UTF-8',
    	'User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36',
	];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $datasss = curl_exec($ch);
    curl_close($ch);
  
  $datasss = json_decode($datasss);
  return $datasss->cssvalidation->result->errorcount;
}

function checkRS($url, $type) {  
  $urkld = parse_url($url);
  $url = $urkld['scheme'].'://'.$urkld['host'];
  
  if ($type == 'robots'){
	  $urlCHECK = $url.'/robots.txt';
  }else if ($type == 'sitemap'){
	  $urlCHECK = $url.'/sitemap.xml';
  }
  
  $ch = curl_init();
  $options = array(
    CURLOPT_URL            => $urlCHECK,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HEADER         => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_ENCODING       => "",
	CURLOPT_SSL_VERIFYPEER => 0,
	CURLOPT_SSL_VERIFYHOST => 0,
    CURLOPT_AUTOREFERER    => true,
    CURLOPT_CONNECTTIMEOUT => 120,
    CURLOPT_TIMEOUT        => 120,
    CURLOPT_MAXREDIRS      => 10,
  );
  curl_setopt_array( $ch, $options );
  $response = curl_exec($ch); 
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if($code == 200){
  	$status = "1";
  }else{
  	$status = "0";
  }
  curl_close($ch);
  return $status;
}

function cServer($server) {  
  if(is_array($server)){
	  $server_res = '';
	  foreach ($server as $key=>$value) {
	  	$server_res .= $value.'; ';
	  }
	  return $server_res;
  }else{
	  return $server;
  }
}

function cCT($ct) {  
  if(is_array($ct)){
	  $ct_res = '';
	  foreach ($ct as $key=>$value) {
	  	$ct_res .= $value.'; ';
	  }
	  return $ct_res;
  }else{
	  return $ct;
  }
}
function idna_convert($url) {
	include_once(SEO_ANALYZER_INC_URL.'functions/idna_convert.class.php');
	$idn = new SEOAnalyzer_idna_convert(array('idn_version'=>2008));
	$punycode=isset($url) ? stripslashes($url) : '';
	$punycode=(stripos($punycode, 'xn--')!==false) ? $idn->decode($punycode) : $idn->encode($punycode);
	return $punycode;
}

//очистка URL
function cleanURL($url) {
	$url = idna_convert($url);	
	$urkld = parse_url($url);
	if(!empty($urkld['host'])){
		$SEOurl = $urkld['host'];
	}else{
		$SEOurl = $urkld['path'];
	}
	if(preg_match("*/*", $SEOurl)){
		$tempArr = explode('/',$SEOurl,2);
		$SEOurl = $tempArr[0];
	}
	$del_tag_w = array("www.", "ftp.", " ");
	$rep_tag_w   = array("", "", "");
	$SEOurl = str_replace($del_tag_w, $rep_tag_w, $SEOurl);
	if (function_exists('mb_strtolower')) {
		$SEOurl = mb_strtolower($SEOurl);
	}else{
		$SEOurl = strtolower($SEOurl);
	}
	return $SEOurl;
}

//очистка URL
function YAurl($url) {
	$urkld = parse_url($url);
	if(!empty($urkld['host'])){
		$SEOurl = $urkld['host'];
	}else{
		$SEOurl = $urkld['path'];
	}
	if(preg_match("*/*", $SEOurl)){
		$tempArr = explode('/',$SEOurl,2);
		$SEOurl = $tempArr[0];
	}
	//$del_tag_w = array("www.", "ftp.", "ftp.");
	//$rep_tag_w   = array("", "");
	//$SEOurl = str_replace($del_tag_w, $rep_tag_w, $SEOurl);
	if (function_exists('mb_strtolower')) {
		$SEOurl = mb_strtolower($SEOurl);
	}else{
		$SEOurl = strtolower($SEOurl);
	}
	return $SEOurl;
}

function cacheExists($domain){
	$dns_cache = SEO_ANALYZER_INC_URL.'/cache/'.$domain.'.dns';
	$whois_cache = SEO_ANALYZER_INC_URL.'/cache/'.$domain.'.whois';
	$Hinfo_cache = SEO_ANALYZER_INC_URL.'/cache/'.$domain.'.hinf';
	$GS_cache = SEO_ANALYZER_INC_URL.'/cache/'.$domain.'.gs';
	$GSm_cache = SEO_ANALYZER_INC_URL.'/cache/'.$domain.'.gsm';
	
	if(file_exists($dns_cache)){
		$DNSc = 'ok';
	}else{
		$dns_data = getSEOcache('http://dotnul.com/api/dns/'.$domain);
		file_put_contents($dns_cache,$dns_data);
		$DNSc = 'ok';
	}
	
	if(file_exists($whois_cache)){
		$WHOISc = 'ok';
	}else{
		$whoisData = rWhoisData($domain);
		file_put_contents($whois_cache,$whoisData);
		$WHOISc = 'ok';
	}
	
	if(file_exists($Hinfo_cache)){
		$Hinfoc = 'ok';
	}else{
		$Hinfo_data = get_siteData($domain);
		file_put_contents($Hinfo_cache,$Hinfo_data);
		$Hinfoc = 'ok';
	}
	
	if(file_exists($GS_cache)){
		$GSc = 'ok';
	}else{
		$GS_data = getSEOcache('https://www.googleapis.com/pagespeedonline/v2/runPagespeed?url=http%3A%2F%2F'.$domain.'&fields=id%2CpageStats%2FtotalRequestBytes%2CresponseCode%2CruleGroups%2Ctitle');
		file_put_contents($GS_cache,$GS_data);
		$GSc = 'ok';
	}
	
	if(file_exists($GSm_cache)){
		$GSmc = 'ok';
	}else{
		$GSm_data  = getSEOcache('https://www.googleapis.com/pagespeedonline/v2/runPagespeed?url=http%3A%2F%2F'.$domain.'&fields=ruleGroups&strategy=mobile');
		file_put_contents($GSm_cache,$GSm_data);
		$GSmc = 'ok';
	}
	
	if(($DNSc == 'ok')&&($WHOISc == 'ok')&&($Hinfoc == 'ok')&&($GSc == 'ok')&&($GSmc == 'ok')){
		//кэш есть
		return true;
	}else{
		return false;
	}	
}

function css_template() {
	$style = get_option('css_template');
	if(empty($style)){
		$style = 'default.css';
	}
	echo '<link href="'.SEO_ANALYZER_THEMES_URL.'/theme/css/template/'.$style.'" rel="stylesheet">';
}

function wpml_list_header(){
	if (function_exists('icl_get_languages')) {
		// Get language array
    	$list = icl_get_languages('skip_missing=1&orderby=id&order=desc'); 
    	if(!empty($list)){
?>
        <div id="wpmlheader" class="btn-group">
        	<button class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
<?php
    		foreach($list as $l){
        		if($l['active'] == 1){
					echo $l['native_name'];
				}
    		}
?>
            <span class="caret"></span></button>
        	<ul class="dropdown-menu">
<?php
    		foreach($list as $l){
        		echo '<li><a href="'.$l['url'].'"><img src="'.$l['country_flag_url'].'" alt="'.$l['native_name'].'"> '.$l['native_name'].'</a></li>';
    		}
?>
        	</ul>
        </div>
<?php
    	}
	}
}


function wpml_list_footer(){
	if (function_exists('icl_get_languages')) {
		// Get language array
    	$list = icl_get_languages('skip_missing=1&orderby=id&order=desc'); 
    	if(!empty($list)){
?>
        <div id="wpmlfooter">
        	<ul>
<?php
    		foreach($list as $l){
        		if($l['active'] == 1){
					echo '<li><img src="'.$l['country_flag_url'].'" alt="'.$l['native_name'].'"> '.$l['native_name'].'</li>';
				}else{
					echo '<li><a href="'.$l['url'].'"><img src="'.$l['country_flag_url'].'" alt="'.$l['native_name'].'"> '.$l['native_name'].'</a></li>';
				}
    		}
?>
        	</ul>
            <hr>
        </div>
<?php
    	}
	}
}
function SEO_hrefseourl(){
	if (get_option('permalink_structure')) {
		if(get_option('SEO_shortcodes')){
			$hrefseourl = get_bloginfo('url').'/'.get_post(get_option('SEO_shortcodes_page'))->post_name.'/seo/';
		}else{
			$hrefseourl = get_bloginfo('url').'/seo/';
		}
	}else{
		if(get_option('SEO_shortcodes')){
			$hrefseourl = get_post(get_option('SEO_shortcodes_page'))->guid.'&seourl=';
		}else{
			$hrefseourl = get_bloginfo('url').'/?seourl=';
		}
	}
	return $hrefseourl;
}

function SEO_action_url($update=false,$domain=NULL){
	if (get_option('permalink_structure')) {
		if(get_option('SEO_shortcodes')){
			//включены
			$SEO_action_url = get_page_link(get_post(get_option('SEO_shortcodes_page'))->ID);
		}else{
			$SEO_action_url = get_bloginfo('url').'/';
		}
		$SEO_action_url_seourl_update = '/?update';
	}else{
		if(get_option('SEO_shortcodes')){
			//включены
			$SEO_action_url = get_post(get_option('SEO_shortcodes_page'))->guid;
		}else{
			$SEO_action_url = get_bloginfo('url');
		}
		$SEO_action_url_seourl_update = '&update';
	}
	if($update==false){
		return $SEO_action_url;
	}else{
		if (get_option('permalink_structure')) {
			return $SEO_action_url.'/seo/'.$domain.$SEO_action_url_seourl_update;
		}else{
			if(get_option('SEO_shortcodes')){
				//включены
				return $SEO_action_url.'&seourl='.$domain.$SEO_action_url_seourl_update;
			}else{
				return $SEO_action_url.'/?seourl='.$domain.$SEO_action_url_seourl_update;
			}
		}
	}
	
}

function SEO_wcc_main($data, $sc=NULL){
	if (!empty($data)) {
		if ($data==='nobody') {
			$action = 'nobody';
			$disabled = ' disabled="disabled"';
		}else if ($data==='register') {
			if (is_user_logged_in()) {
				$action = 'all';
			}else{
				$action = 'register';
			}
			$disabled = '';
		}
	}else{
		$action = 'all';
		$disabled = '';
	}
	
	$SEO_action_url_seourl = SEO_action_url();
?>
					<form class="form-inline" role="form" action="<?php echo $SEO_action_url_seourl; ?>" method="post" id="seoinfosite">
					  <div class="form-group">
					    <input type="text" class="form-control" name="seourl" id="seourl" placeholder="google.com"<?php echo $disabled; ?>>
					  </div>
					  <button type="submit" class="btn chech_site btn-lg" id="seourlbtn" disabled="disabled"><i class="fa fa-search"></i> <?php echo __( 'Check', 'seoanalyzer' ); ?></button>
					</form>	
<?php if ($action==='all') { ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
		$('#seourl').keyup(function(){
        	if($(this).val().length !=0)
            	$('#seourlbtn').attr('disabled', false);            
        	else
            	$('#seourlbtn').attr('disabled',true);
		});
		
		$("#seoinfosite").on("submit", function(event) {
			event.preventDefault();
			var data_seourl = $('#seourl').val();
			jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {cleanURL: data_seourl}).done(function(data) {
				data_seourl = data;
			});
			$.ajax({
				type: "POST",
				url: "<?php echo $SEO_action_url_seourl; ?>",
				data: $(this).serialize(),
				success: function(msg) {
					if(msg == 'socket_error') {
						jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
							if(data == 'ok') {
								window.location.replace("<?php echo SEO_hrefseourl(); ?>" + data_seourl);
							} else {
								jQuery('body').removeClass('loading');
								sweetAlert("<?php echo __( '504 Gateway Timeout!', 'seoanalyzer' ); ?>", "<?php echo __( 'Try again!', 'seoanalyzer' ); ?>", "error");
							}
						});
					} else if(msg == 'ok') {
						window.location.replace("<?php echo SEO_hrefseourl(); ?>" + data_seourl);
					} else {
						jQuery('body').removeClass('loading');
						sweetAlert("<?php echo __( 'Error!', 'seoanalyzer' ); ?>", "<?php echo __( 'An error occurred while running the script. Try again!', 'seoanalyzer' ); ?>", "error");
					}
				},
				statusCode: {
					404: function() {
						jQuery('body').removeClass('loading');
						sweetAlert("<?php echo __( 'Oops...', 'seoanalyzer' ); ?>", "<?php echo __( 'Your requested site is offline!', 'seoanalyzer' ); ?>", "error");
					},
					418: function() {
						jQuery('body').removeClass('loading');
						sweetAlert("<?php echo __( 'Oops...', 'seoanalyzer' ); ?>", "<?php echo __( 'Not a Valid Domain!', 'seoanalyzer' ); ?>", "error");
					},
					500: function() {
						jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
							if(data == 'ok') {
								window.location.replace("<?php echo SEO_hrefseourl(); ?>" + data_seourl);
							} else {
								jQuery('body').removeClass('loading');
								sweetAlert("<?php echo __( 'Error!', 'seoanalyzer' ); ?>", "<?php echo __( 'An error occurred while running the script. Try again!', 'seoanalyzer' ); ?>", "error");
							}
						});
					},
					504: function() {
						jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
							if(data == 'ok') {
								window.location.replace("<?php echo SEO_hrefseourl(); ?>" + data_seourl);
							} else {
								jQuery('body').removeClass('loading');
								sweetAlert("<?php echo __( '504 Gateway Timeout!', 'seoanalyzer' ); ?>", "<?php echo __( 'Try again!', 'seoanalyzer' ); ?>", "error");
							}
						});
					}
				}
			});
			return false;
		});
    });
    </script>
<?php
}else if ($action==='register') { ?>
                <script type="text/javascript">
                	jQuery(document).ready(function($) {
                		$('#seourl').keyup(function(){
                			if($(this).val().length !=0)
                				$('#seourlbtn').attr('disabled', false);            
                		else
                				$('#seourlbtn').attr('disabled',true);
                		});
		
                		$("#seoinfosite").on("submit", function(event) {
                			jQuery('body').removeClass('loading');
							swal({
								title: "<?php echo __( 'Authorization error!', 'seoanalyzer' ); ?>",
								text: "<?php echo __( 'You need to', 'seoanalyzer' ); ?> <a href='<?php echo wp_login_url( get_permalink() ); ?>' title='<?php echo __( 'login', 'seoanalyzer' ); ?>'><?php echo __( 'login', 'seoanalyzer' ); ?></a> <?php echo __( 'or', 'seoanalyzer' ); ?> <a href='<?php echo wp_registration_url(); ?>' title='<?php echo __( 'signup', 'seoanalyzer' ); ?>'><?php echo __( 'signup', 'seoanalyzer' ); ?></a> <?php echo __( 'to use', 'seoanalyzer' ); ?> <?php bloginfo('name'); ?>",
								type: "warning",
								html: true
								});
                			return false;
                		});
                	});
                </script>
<?php
}
}

function SEO_wcc_inner($data){
	if (!empty($data)) {
		if ($data==='nobody') {
			$action = 'nobody';
			$disabled = ' disabled="disabled"';
		}else if ($data==='register') {
			if (is_user_logged_in()) {
				$action = 'all';
			}else{
				$action = 'register';
			}
			$disabled = '';
		}
	}else{
		$action = 'all';
		$disabled = '';
	}
	
	$SEO_action_url_seourl = SEO_action_url();
?>
        	<form class="form-inline" role="form" action="<?php echo $SEO_action_url_seourl; ?>" method="post" id="seoinfositeseourl">
        		<input type="text" class="form-control" name="seourl" id="seourl" placeholder="google.com"<?php echo $disabled; ?>>
        		<button type="submit" class="btn chech_site" id="seourlbtn" disabled="disabled"><i class="fa fa-search"></i> <?php echo __( 'Check', 'seoanalyzer' ); ?></button>
        	</form>	
<?php if ($action==='all') { ?>
                <script type="text/javascript">
                	jQuery(document).ready(function($) {
                		$('#seourl').keyup(function(){
                			if($(this).val().length !=0)
                				$('#seourlbtn').attr('disabled', false);            
                		else
                				$('#seourlbtn').attr('disabled',true);
                		});
		
                		$("#seoinfositeseourl").on("submit", function(event) {
                			event.preventDefault();
                			var data_seourl = $('#seourl').val();
							jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {cleanURL: data_seourl}).done(function(data) {
								data_seourl = data;
							});
                			$.ajax({
                				type: "POST",
                				url: "<?php echo $SEO_action_url_seourl; ?>",
                				data: $(this).serialize(),
                				success: function(msg) {
                					if(msg == 'socket_error') {
										jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
                							if(data == 'ok') {
                								window.location.replace("<?php echo SEO_hrefseourl(); ?>" + data_seourl);
                							} else {
                								jQuery('body').removeClass('loading');
                								sweetAlert("<?php echo __( '504 Gateway Timeout!', 'seoanalyzer' ); ?>", "<?php echo __( 'Try again!', 'seoanalyzer' ); ?>", "error");
                							}
										});
                					} else if(msg == 'ok') {
                						window.location.replace("<?php echo SEO_hrefseourl(); ?>" + data_seourl);
                					} else {
                						jQuery('body').removeClass('loading');
                						sweetAlert("<?php echo __( 'Error!', 'seoanalyzer' ); ?>", "<?php echo __( 'An error occurred while running the script. Try again!', 'seoanalyzer' ); ?>", "error");
                					}
                				},
                				statusCode: {
                					404: function() {
                						jQuery('body').removeClass('loading');
                						sweetAlert("<?php echo __( 'Oops...', 'seoanalyzer' ); ?>", "<?php echo __( 'Your requested site is offline!', 'seoanalyzer' ); ?>", "error");
                					},
                					418: function() {
                						jQuery('body').removeClass('loading');
                						sweetAlert("<?php echo __( 'Oops...', 'seoanalyzer' ); ?>", "<?php echo __( 'Not a Valid Domain!', 'seoanalyzer' ); ?>", "error");
                					},
                					500: function() {
										jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
											if(data == 'ok') {
												window.location.replace("<?php echo SEO_hrefseourl(); ?>" + data_seourl);
											} else {
												jQuery('body').removeClass('loading');
												sweetAlert("<?php echo __( 'Error!', 'seoanalyzer' ); ?>", "<?php echo __( 'An error occurred while running the script. Try again!', 'seoanalyzer' ); ?>", "error");
											}
										});
                					},
                					504: function() {
										jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
                							if(data == 'ok') {
                								window.location.replace("<?php echo SEO_hrefseourl(); ?>" + data_seourl);
                							} else {
                								jQuery('body').removeClass('loading');
                								sweetAlert("<?php echo __( '504 Gateway Timeout!', 'seoanalyzer' ); ?>", "<?php echo __( 'Try again!', 'seoanalyzer' ); ?>", "error");
                							}
										});
                					}
                				}
                			});
                			return false;
                		});

                	});
                </script>
<?php
}else if ($action==='register') { ?>
                <script type="text/javascript">
                	jQuery(document).ready(function($) {
                		$('#seourl').keyup(function(){
                			if($(this).val().length !=0)
                				$('#seourlbtn').attr('disabled', false);            
                		else
                				$('#seourlbtn').attr('disabled',true);
                		});
		
                		$("#seoinfositeseourl").on("submit", function(event) {
                			jQuery('body').removeClass('loading');
							swal({
								title: "<?php echo __( 'Authorization error!', 'seoanalyzer' ); ?>",
								text: "<?php echo __( 'You need to', 'seoanalyzer' ); ?> <a href='<?php echo wp_login_url( get_permalink() ); ?>' title='<?php echo __( 'login', 'seoanalyzer' ); ?>'><?php echo __( 'login', 'seoanalyzer' ); ?></a> <?php echo __( 'or', 'seoanalyzer' ); ?> <a href='<?php echo wp_registration_url(); ?>' title='<?php echo __( 'signup', 'seoanalyzer' ); ?>'><?php echo __( 'signup', 'seoanalyzer' ); ?></a> <?php echo __( 'to use', 'seoanalyzer' ); ?> <?php bloginfo('name'); ?>",
								type: "warning",
								html: true
								});
                			return false;
                		});
                	});
                </script>
<?php
}
}

function SEO_wcc_update($data, $domain, $siteupdate){
	if (!empty($data)) {
		if ($data==='nobody') {
			$action = 'nobody';
		}else if ($data==='register') {
			if (is_user_logged_in()) {
				$action = 'all';
			}else{
				$action = 'register';
			}
		}
	}else{
		$action = 'all';
	}
	
	$SEO_action_url_seourl = SEO_action_url();
	
	if (get_option('upd_SEO_info')){
		$today = time();
		$moon =  date('U', strtotime($siteupdate));
		if (((floor(($today - $moon) / 86400))>=get_option('upd_SEO_info'))&&($action==='all')){
?>
        	<form role="form" action="<?php echo $SEO_action_url_seourl; ?>" method="post" id="uptseoinfo">
            	<input type="hidden" name="upd" value="<?php echo $domain; ?>">
            	<button type="submit" class="btn btn-default" id="seourlbtnUPD"><i class="fa fa-refresh"></i> <?php echo __( 'update seo information', 'seoanalyzer' ); ?></button>
            </form>
<?php 
		}
	}
?>

<?php if ($action==='all') {
		if (get_option('upd_SEO_info')){
			if ((floor(($today - $moon) / 86400))>=get_option('upd_SEO_info')){ ?>
                <script type="text/javascript">
                	jQuery(document).ready(function($) {	
                		$("#uptseoinfo").on("submit", function(event) {
                			event.preventDefault();
                			$.ajax({
                				type: "POST",
                				url: "<?php echo $SEO_action_url_seourl; ?>",
                				data: $(this).serialize(),
                				success: function(msg) {
                					if(msg == 'socket_error') {
										jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
                							if(data == 'ok') {
                								window.location.replace("<?php echo SEO_action_url(true,$domain); ?>");
                							} else {
                								jQuery('body').removeClass('loading');
                								sweetAlert("<?php echo __( '504 Gateway Timeout!', 'seoanalyzer' ); ?>", "<?php echo __( 'Try again!', 'seoanalyzer' ); ?>", "error");
                							}
										});
                					} else if(msg == 'ok') {
                						window.location.replace("<?php echo SEO_action_url(true,$domain); ?>");
                					} else {
                						jQuery('body').removeClass('loading');
                						sweetAlert("<?php echo __( 'Error!', 'seoanalyzer' ); ?>", "<?php echo __( 'An error occurred while running the script. Try again!', 'seoanalyzer' ); ?>", "error");
                					}
                				},
                				statusCode: {
                					404: function() {
                						jQuery('body').removeClass('loading');
                						sweetAlert("<?php echo __( 'Oops...', 'seoanalyzer' ); ?>", "<?php echo __( 'Your requested site is offline!', 'seoanalyzer' ); ?>", "error");
                					},
                					418: function() {
                						jQuery('body').removeClass('loading');
                						sweetAlert("<?php echo __( 'Oops...', 'seoanalyzer' ); ?>", "<?php echo __( 'Not a Valid Domain!', 'seoanalyzer' ); ?>", "error");
                					},
                					500: function() {
										jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
											if(data == 'ok') {
												window.location.replace("<?php echo SEO_action_url(true,$domain); ?>");
											} else {
												jQuery('body').removeClass('loading');
												sweetAlert("<?php echo __( 'Error!', 'seoanalyzer' ); ?>", "<?php echo __( 'An error occurred while running the script. Try again!', 'seoanalyzer' ); ?>", "error");
											}
										});
                					},
                					504: function() {
										jQuery.post( "<?php echo $SEO_action_url_seourl; ?>", {seourl: data_seourl}).done(function(data) {
                							if(data == 'ok') {
                								window.location.replace("<?php echo SEO_action_url(true,$domain); ?>");
                							} else {
                								jQuery('body').removeClass('loading');
                								sweetAlert("<?php echo __( '504 Gateway Timeout!', 'seoanalyzer' ); ?>", "<?php echo __( 'Try again!', 'seoanalyzer' ); ?>", "error");
                							}
										});
                					}
                				}
                			});
                			return false;
                		});

                	});
                </script>
<?php
			}
		}
}else if ($action==='register') { ?>
                <script type="text/javascript">
                	jQuery(document).ready(function($) {
                		$("#uptseoinfo").on("submit", function(event) {
                			jQuery('body').removeClass('loading');
							swal({
								title: "<?php echo __( 'Authorization error!', 'seoanalyzer' ); ?>",
								text: "<?php echo __( 'You need to', 'seoanalyzer' ); ?> <a href='<?php echo wp_login_url( get_permalink() ); ?>' title='<?php echo __( 'login', 'seoanalyzer' ); ?>'><?php echo __( 'login', 'seoanalyzer' ); ?></a> <?php echo __( 'or', 'seoanalyzer' ); ?> <a href='<?php echo wp_registration_url(); ?>' title='<?php echo __( 'signup', 'seoanalyzer' ); ?>'><?php echo __( 'signup', 'seoanalyzer' ); ?></a> <?php echo __( 'to use', 'seoanalyzer' ); ?> <?php bloginfo('name'); ?>",
								type: "warning",
								html: true
								});
                			return false;
                		});
                	});
                </script>
<?php
}
}

?>
